
        int minRobeza = vards.Length;
        int maxRobeza = vards.Length + uzvards.Length;

        // Aizpilda ar skaitļiem
        for (int i = 1; i < rows; i++)
            for (int j = 1; j <= formVards.Length; j++)
                dati[i, j] = rnd.Next(minRobeza, maxRobeza + 1);

        // Aprēķina rindām sum/min/max
        for (int i = 1; i < rows; i++)
        {
            int sum = 0, min = int.MaxValue, max = int.MinValue;
            for (int j = 1; j <= formVards.Length; j++)
            {
                int val = dati[i, j];
                sum += val;
                if (val < min) min = val;
                if (val > max) max = val;
            }
            dati[i, cols - 3] = sum;
            dati[i, cols - 2] = min;
            dati[i, cols - 1] = max;
        }

        // === 1. TABULA ===
        Console.WriteLine("\n*====*==================*=====*=====*=====*");
        Console.Write("|    |");
        foreach (char c in formVards)
            Console.Write($" {c,-2} |");
        Console.Write("sum |min |max |\n");
        Console.WriteLine("*====*==================*=====*=====*=====*");

        for (int i = 1; i < rows; i++)
        {
            Console.Write($"| {formUzvards[formUzvards.Length - i]}  |");
            for (int j = 1; j <= formVards.Length; j++)
                Console.Write($" {dati[i, j],2} |");
            Console.Write($" {dati[i, cols - 3],3} | {dati[i, cols - 2],3} | {dati[i, cols - 1],3} |\n");
        }

        Console.WriteLine("*====*==================*=====*=====*=====*");

        string[] labels = { "sum", "min", "max" };
        for (int l = 0; l < 3; l++)
        {
            Console.Write($"| {labels[l],-3}|");
            for (int j = 1; j <= formVards.Length; j++)
            {
                int sum = 0, min = int.MaxValue, max = int.MinValue;
                for (int i = 1; i < rows; i++)
                {
                    int val = dati[i, j];
                    sum += val;
                    if (val < min) min = val;
                    if (val > max) max = val;
                }
                if (l == 0) Console.Write($" {sum,2} |");
                else if (l == 1) Console.Write($" {min,2} |");
                else Console.Write($" {max,2} |");
            }
            Console.Write("  * |  * |  * |\n");
        }
        Console.WriteLine("*====*==================*=====*=====*=====*\n");

        // === 2. TABULA: TRANSPOZĒTĀ ===
        int[,] transponets = new int[formVards.Length + 1, formUzvards.Length + 4];

        // Pārsūta vērtības
        for (int i = 1; i < rows; i++)
            for (int j = 1; j <= formVards.Length; j++)
                transponets[j, i] = dati[i, j];

        // Aprēķini rindām
        for (int i = 1; i <= formVards.Length; i++)
        {
            int sum = 0, min = int.MaxValue, max = int.MinValue;
            for (int j = 1; j < rows; j++)
            {
                int val = transponets[i, j];
                sum += val;
                if (val < min) min = val;
                if (val > max) max = val;
            }
            transponets[i, formUzvards.Length + 1] = sum;
            transponets[i, formUzvards.Length + 2] = min;
            transponets[i, formUzvards.Length + 3] = max;
        }

        // Otrā tabula
        Console.WriteLine("\n*====*============================*=====*=====*=====*");
        Console.Write("| X  |");
        foreach (char c in formUzvards)
            Console.Write($" {c,-2} |");
        Console.Write("sum |min |max |\n");
        Console.WriteLine("*====*============================*=====*=====*=====*");

        for (int i = 1; i <= formVards.Length; i++)
        {
            Console.Write($"| {formVards[i - 1],-2} |");
            for (int j = 1; j <= formUzvards.Length; j++)
                Console.Write($" {transponets[i, j],2} |");
            Console.Write($" {transponets[i, formUzvards.Length + 1],3} |");
            Console.Write($" {transponets[i, formUzvards.Length + 2],3} |");
            Console.Write($" {transponets[i, formUzvards.Length + 3],3} |\n");
        }

        Console.WriteLine("*====*============================*=====*=====*=====*");

        // Kolonnu aprēķini (sum/min/max)
        for (int l = 0; l < 3; l++)
        {
            Console.Write($"| {labels[l],-3}|");
            for (int j = 1; j <= formUzvards.Length; j++)
            {
                int sum = 0, min = int.MaxValue, max = int.MinValue;
                for (int i = 1; i <= formVards.Length; i++)
                {
                    int val = transponets[i, j];
                    sum += val;
                    if (val < min) min = val;
                    if (val > max) max = val;
                }

                if (l == 0) Console.Write($" {sum,2} |");
                else if (l == 1) Console.Write($" {min,2} |");
                else Console.Write($" {max,2} |");
            }
            Console.Write("  * |  * |  * |\n");
        }
        Console.WriteLine("*====*============================*=====*=====*=====*");
    }

    static string KatrsOtraisLielais(string teksts)
    {
        char[] masivs = teksts.ToCharArray();
        for (int i = 0; i < masivs.Length; i++)
        {
            masivs[i] = i % 2 == 0 ? Char.ToUpper(masivs[i]) : Char.ToLower(masivs[i]);
        }
        return new string(masivs);
    }
}